// VH73BBlueTooth.cpp : implementation file
//

#include "stdafx.h"
#include "hhda.h"
#include "hhdaBlueTooth.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//////////////////////////////////////////////////////////////////////////
HWND	gBlueToothHwnd	=	NULL;	//bluetooth

/////////////////////////////////////////////////////////////////////////////
// VH73BBlueTooth property page

IMPLEMENT_DYNCREATE(VH73BBlueTooth, CPropertyPage)

VH73BBlueTooth::VH73BBlueTooth() : CPropertyPage(VH73BBlueTooth::IDD)
{
	//{{AFX_DATA_INIT(VH73BBlueTooth)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

VH73BBlueTooth::~VH73BBlueTooth()
{
}

void VH73BBlueTooth::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(VH73BBlueTooth)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(VH73BBlueTooth, CPropertyPage)
	//{{AFX_MSG_MAP(VH73BBlueTooth)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_GETBLUENAME, OnButtonGetbluename)
	ON_BN_CLICKED(IDC_BUTTON_SETBLUENAME, OnButtonSetbluename)
	ON_BN_CLICKED(IDC_BUTTON_GETBLUERATE, OnButtonGetbluerate)
	ON_BN_CLICKED(IDC_BUTTON_SETBLUERATE, OnButtonSetbluerate)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_READERBLUETOOTHMSG, OnReaderBlueToothmsg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// VH73BBlueTooth message handlers

void VH73BBlueTooth::OnInitUIText()	//
{
	SetWindowText(theApp.g_LoadString("IDWQE_D0001"));//
	
	GetDlgItem(IDC_STATIC_BLUENAME)->SetWindowText(theApp.g_LoadString("IDWQE_D0002"));//
	GetDlgItem(IDC_BUTTON_SETBLUENAME)->SetWindowText(theApp.g_LoadString("IDWQE_D0003"));//
	GetDlgItem(IDC_BUTTON_GETBLUENAME)->SetWindowText(theApp.g_LoadString("IDWQE_D0004"));//ȡ
	//GetDlgItem(IDC_STATIC_BLUEID)->SetWindowText(theApp.g_LoadString("IDWQE_D0005"));//VH73ID
	//GetDlgItem(IDC_BUTTON_SETID)->SetWindowText(theApp.g_LoadString("IDWQE_D0006"));//ID
	//GetDlgItem(IDC_BUTTON_GETBLUEID)->SetWindowText(theApp.g_LoadString("IDWQE_D0007"));//ȡID
	GetDlgItem(IDC_STATIC_BLUERATE)->SetWindowText(theApp.g_LoadString("IDWQE_D0008"));//
	GetDlgItem(IDC_BUTTON_SETBLUERATE)->SetWindowText(theApp.g_LoadString("IDWQE_D0009"));//
	GetDlgItem(IDC_BUTTON_GETBLUERATE)->SetWindowText(theApp.g_LoadString("IDWQE_D0010"));//ȡ
	GetDlgItem(IDC_STATIC_BLUEBLUE)->SetWindowText(theApp.g_LoadString("IDWQE_D0011"));//



}

void VH73BBlueTooth::UpdateStatus()//ʹ벻ʹ
{
	GetDlgItem(IDC_BUTTON_SETBLUENAME)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_GETBLUENAME)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_SETBLUERATE)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_GETBLUERATE)->EnableWindow(ifConnectReader);
	
	if ( 3 == ConnectMode )
	{
		//USB,
	}
	else
	{
		GetDlgItem(IDC_BUTTON_SETBLUENAME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_GETBLUENAME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_SETBLUERATE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_GETBLUERATE)->EnableWindow(FALSE);
	}
}

BOOL VH73BBlueTooth::OnSetActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	//////////////////////////////////////////////////////////////////////////
	UpdateStatus();//ʹ벻ʹ

	return CPropertyPage::OnSetActive();
}

BOOL VH73BBlueTooth::OnKillActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CPropertyPage::OnKillActive();
}

BOOL VH73BBlueTooth::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	gBlueToothHwnd	=	this->GetSafeHwnd();


	CComboBox *m_BtRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_BLUERAET);
	m_BtRate->AddString("9600");
	m_BtRate->AddString("19200");
	m_BtRate->AddString("38400");
	m_BtRate->AddString("57600");
	m_BtRate->AddString("115200");
	m_BtRate->SetCurSel(0);


	//////////////////////////////////////////////////////////////////////////
	UpdateStatus();//ʹ벻ʹ


	//
	::PostMessage(gBlueToothHwnd,WM_READERBLUETOOTHMSG,2,0);	//convert language
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void VH73BBlueTooth::OnDestroy()
{
	CPropertyPage::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

void VH73BBlueTooth::OnButtonGetbluename()
{
	// TODO: Add your control notification handler code here
	//ȡ
	int res;
	CString str;
	
	BYTE sReaderID[32]	=	{0};
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	memset(sReaderID,0,32);
	res=GetBluetoothName(m_hScanner,sReaderID);
	
	str.Empty(); 
	if(res==_OK)
	{
		for(int i=0;i<10;i++)
		{
			if(sReaderID[i]==0x00)
			{
				break;
			}
			str+=sReaderID[i];
		}
		GetDlgItem(IDC_EDIT_BLUENAME)->SetWindowText(str);
	}
	else
	{
		//MessageBox("ȡƴ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0012"));
	}
	
	UpdateData(FALSE);

	return;
}

void VH73BBlueTooth::OnButtonSetbluename()
{
	// TODO: Add your control notification handler code here
	//
	int res;
	
	BYTE sReaderID[32];
	CString m_BtName	=	_T("");
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	UpdateData(TRUE);

	GetDlgItem(IDC_EDIT_BLUENAME)->GetWindowText(m_BtName);
	if((m_BtName.GetLength()<=0)||(m_BtName.GetLength()>10))
	{
		//MessageBox("!");
		MessageBox(theApp.g_LoadString("IDWQE_D0013"));
		return;
	}
	
	int nLen=m_BtName.GetLength(); 
	
	memset(sReaderID,0,32);
	memcpy(sReaderID,m_BtName.GetBuffer(m_BtName.GetLength()),nLen); 
	
	res=SetBluetoothName(m_hScanner,nLen,sReaderID);
	
	if(res==_OK)
	{
		//MessageBox("óɹ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0014"));
	}
	else
	{
		//MessageBox("ô!");
		MessageBox(theApp.g_LoadString("IDWQE_D0015"));
	}

	return;
}




void VH73BBlueTooth::OnButtonGetbluerate()
{
	// TODO: Add your control notification handler code here
	//ȡ
	int res;
	
	
	BYTE sReaderID;
	
	CComboBox *m_BtRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_BLUERAET);

	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	res=GetBtBaudRate(m_hScanner,&sReaderID);
	
	if(res==_OK)
	{
		m_BtRate->SetCurSel(sReaderID-4); 
	}
	else
	{
		//MessageBox("ȡʴ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0020"));
	}
	
	UpdateData(FALSE);

	return;
}

void VH73BBlueTooth::OnButtonSetbluerate()
{
	// TODO: Add your control notification handler code here
	//
	int res;
	CString str;
	
	BYTE sReaderID;
	
	CComboBox *m_BtRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_BLUERAET);

	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	UpdateData(TRUE);
	
	sReaderID=m_BtRate->GetCurSel()+4;  
	
	if((sReaderID<4)||(sReaderID>8))
	{
		//MessageBox("ô!");
		MessageBox(theApp.g_LoadString("IDWQE_D0021"));
		return;
	}
	
	res=SetBtBaudRate(m_hScanner,sReaderID);
	
	if(res==_OK)
	{
		//MessageBox("óɹ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0022"));
	}
	else
	{
		//MessageBox("ô!");
		MessageBox(theApp.g_LoadString("IDWQE_D0023"));
	}

	return;
}

//WM_READERBLUETOOTHMSG
afx_msg LRESULT VH73BBlueTooth::OnReaderBlueToothmsg(WPARAM wParam, LPARAM lParam)
{
	int iwParam	=	(int)wParam;
	int ilParam	=	(int)lParam;
	
	if ( 2 == iwParam )
	{
		OnInitUIText();	//
	}
	else if ( 4 == iwParam )
	{
		if ( 0 == ilParam )
		{
			UpdateStatus();//ʹ벻ʹ
		}
	}
	
	return 0;

}


